/* eslint-disable vars-on-top,max-len */
// normally the model is passed to the view instead of the view creating the model
define([
    'underscore',
    'backbone',
    'App',
    'marionette',
    'modules/new-appointment-wizard/wizard-section-view',
    'modules/page/popup/external-nav-popup-view',
    'json!modules/community-care-request/new-appointment-request-question/service-distance-selection/community-care-service-distance.json',
    'text!modules/community-care-request/new-appointment-request-question/service-distance-selection/service-section-template.html',
],
function(
    _,
    Backbone,
    app,
    Marionette,
    WizardSectionView,
    ExternalNavigationWarningPopup,
    metadata,
    serviceSectionTemplate
) {
    'use strict';

    return WizardSectionView.extend({
        events: {
            'popupafterclose': 'queuePopupOrDestroy',
            'click .external-link': 'openExternalLink',
        },
        initialize: function(options) {
            var sectionName = 'service-section';
            var serviceQuestionModel;
            var updatedServiceQuestion;
            this.ccFeatureEnabled = options.ccFeatureEnabled;
            this._initializeSection(options, sectionName, metadata, options.model.get('steps')[0]);
            serviceQuestionModel = this.collection.get('service');
            updatedServiceQuestion = _.find(serviceQuestionModel.get('values'), {id: 'community-care-appointments'});
            updatedServiceQuestion.ccFeatureEnabled = this.ccFeatureEnabled;
            // initialize listener to 'change:value' after static values are set
            this.initializeQuestionEventListeners();

            // options.patientEnrolledFacilities is a $.Deferred object but resolved before passed in
            // we just want to determine if at least 1 facility is supported
            var areAnyFacilitiesSupportedForPatient = options.patientEnrolledFacilities.find(function(facility) {
                return facility.get('supportsVAR');
            });
 
            if (updatedServiceQuestion.ccFeatureEnabled === true) {
                updatedServiceQuestion.text = '<span>Community Care Appointments (Distance Eligible Veterans)</span>';
            }

            if (!areAnyFacilitiesSupportedForPatient) {
                updatedServiceQuestion.disabled = true;
                updatedServiceQuestion.approvedProviders = app.externalLinks.get('approved-providers').toJSON();
                updatedServiceQuestion.value = updatedServiceQuestion.ccFeatureEnabled === true ?
                    'Community Care Appointments (Distance Eligible Veterans)' :
                    'Community Care (Distance Eligible Veterans)';
                updatedServiceQuestion.text = _.template(serviceSectionTemplate)(updatedServiceQuestion);
                // force selection of VA appointments
                var vaAppointmentValue = _.find(serviceQuestionModel.get('values'), {id: 'va-appointments'});
                this.model.set('service', vaAppointmentValue.value);
            }
        },
        openExternalLink: function(e) {
            var $link;
            var navigationWarning;

            e.preventDefault();

            $link = $(e.currentTarget);
            navigationWarning = new (ExternalNavigationWarningPopup.extend({focusOnElAfterClose: _.noop}))({
                elAfterClose: $link,
                model: new Backbone.Model({href: $link.attr('href')}),
            });
            navigationWarning.openPopup();
        },
    });
});
